<?php
/**
 * The template for displaying Category pages
 *
 * Used to display archive-type pages for posts in a category.
 *
 * @link http://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage Twenty_Twelve
 * @since Twenty Twelve 1.0
 */

get_header(); ?>

	<section id="primary" class="site-content column">
		<div id="content" role="main">

<!-- breadcrumbs -->
<header class="archive-header">
<?php if  ( ! is_home() ) : ?>
<div class="breadcrumbs">
<i class="fa fa-home"></i><?php if(function_exists('bcn_display'))
    {
        bcn_display();
    }?>
</div>
<?php endif; ?>
			</header><!-- .breadcrumbs -->
            
		<?php if ( have_posts() ) : ?>
			<?php if ( category_description() ) : // Show an optional category description ?>
            <header class="archive-header">			
				<div class="archive-meta"><?php echo category_description(); ?></div>
			</header><!-- .archive-header -->
			<?php endif; ?>

			<?php
			/* Start the Loop */
			while ( have_posts() ) : the_post();

				/* Include the post format-specific template for the content. If you want to
				 * this in a child theme then include a file called called content-___.php
				 * (where ___ is the post format) and that will be used instead.
				 */
				get_template_part( 'content', get_post_format() );

			endwhile;

			twentytwelve_content_nav( 'nav-below' );
			?>

		<?php else : ?>
			<?php get_template_part( 'content', 'none' ); ?>
		<?php endif; ?>

		</div><!-- #content -->
	</section><!-- #primary -->

<?php get_sidebar(); ?>
<?php get_footer(); ?>